
## This script will rebuild the website following changes to the R package and the Downloads repository.

## If a new implementation region is added then a new vignette needs to be built and the sf object containing implementations updated.
## If a new version of the package is released, and the documents linked off the home page need to be bumped a version, then change the version number in the urls in the .yml file
## If we stop supporting R 3.6 at any point then the vignettes will need to be revisited for the automatic link building.

pkgdown::build_site()                

# Fix image paths in footers outside of index

library(tidyverse)

c(list.files("./docs/articles/", pattern = ".html", full.names = TRUE),
  list.files("./docs/news/", pattern = ".html", full.names = TRUE),
  list.files("./docs/reference/", pattern = ".html", full.names = TRUE)) %>%         # list pages for correction 
  walk(~{

readLines(.x) %>%                                                                # Read webpage
  str_replace_all("reference/figures", "../reference/figures") %>%               # Correct incorrect path to figures for footer image
  writeLines(.x)                                                                 # overwrite file

  })
